/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.vw.base.logging.Logger;
import filenet.vw.soap.server.IVWSOAPContext;
import filenet.vw.soap.server.IVWSOAPSessionManager;
import filenet.vw.soap.server.VWRouterServlet;
import filenet.vw.soap.server.VWSOAPService;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;

public class VWSOAPServiceProvider
extends RPCJavaProvider
implements IVWSOAPSessionManager {
    private VWSOAPSessionInfo peregrineSession;
    private static final Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static final String m_className = "VWSOAPServiceProvider";

    public void setSession(VWSOAPSessionInfo ses) {
        this.peregrineSession = ses;
    }

    public VWSOAPSessionInfo getSession() {
        return this.peregrineSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servlet = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession session = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = dd;
        this.call = call;
        this.targetObjectURI = targetObjectURI;
        this.servlet = servlet;
        this.session = session;
        ServletConfig config = servlet.getServletConfig();
        ServletContext context = config.getServletContext();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)context);
        if (!RPCRouter.validCall((DeploymentDescriptor)dd, (Call)call)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            this.targetObject = session.getAttribute(targetObjectURI);
            if (this.targetObject == null) {
                this.targetObject = new VWSOAPService();
                session.setAttribute(targetObjectURI, this.targetObject);
            }
            if (this.targetObject != null && this.targetObject instanceof IVWSOAPContext && servlet instanceof VWRouterServlet) {
                ((VWRouterServlet)servlet).setVWSOAPContext((IVWSOAPContext)this.targetObject, this.peregrineSession);
            }
        }
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        String m_method = "invoke0_" + this.call.getMethodName();
        try {
            Response resp = this.invoke(resContext);
            Envelope env = resp.buildEnvelope();
            StringWriter sw = new StringWriter();
            env.marshall((Writer)sw, (XMLJavaMappingRegistry)this.call.getSOAPMappingRegistry(), resContext);
            resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception e) {
            if (e instanceof SOAPException) {
                throw (SOAPException)((Object)e);
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e.toString());
        }
    }

    public Response invoke(SOAPContext resContext) throws SOAPException {
        String m_method = "invoke1_" + this.call.getMethodName();
        Vector params = this.call.getParams();
        String respEncStyle = this.call.getEncodingStyleURI();
        Object[] args = null;
        Class[] argTypes = null;
        if (params != null) {
            int paramsCount = params.size();
            args = new Object[paramsCount];
            argTypes = new Class[paramsCount];
            for (int i = 0; i < paramsCount; ++i) {
                Parameter param = (Parameter)params.elementAt(i);
                args[i] = param.getValue();
                argTypes[i] = param.getType();
                if (respEncStyle != null) continue;
                respEncStyle = param.getEncodingStyleURI();
            }
        }
        if (respEncStyle == null) {
            respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Bean result = null;
        try {
            Method m = MethodUtils.getMethod((Object)this.targetObject, (String)this.call.getMethodName(), (Class[])argTypes);
            result = new Bean(m.getReturnType(), m.invoke(this.targetObject, args));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        Parameter ret = null;
        if (result.type != Void.TYPE) {
            ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
        }
        return new Response(this.call.getTargetObjectURI(), this.call.getMethodName(), ret, null, null, respEncStyle, resContext);
    }
}

